﻿/**
 * Create by Simon Blouin and by Nick.com
 * This is the controller of the High Score
 * All functions related to high score can be found here
 */
 
//! This will hide or show the high score buttons
var G_ShowHighScore:Boolean = true;
//! This will test the highscore, show all traces and logon automaticly.
var G_TestHighScore:Boolean = false;

/**
 * Nick High Score system
 */
 
/**
 * The will get the scores from the proxy
 */
function getScores() {
	if (G_TestHighScore==true) {
		trace("getScores")
	}
	if (gProxyObj == undefined) {
		if (G_TestHighScore==true) {
			trace("dans getscore, listescore")
		}
		listScores();
	} else {
		if (G_TestHighScore==true) {
			trace("dans getscore, getScores")
		}
		gProxyObj.getScores(cbFunc2);
	}
};

/**
 * This will send the score to Nick's Database
 * @param  theScore -> The score to send to Nick
 */
function submitScore(theScore) {
	if (G_TestHighScore==true) {
		trace("Envoie le score = "+theScore)
	}
	gProxyObj.submitScore(theScore, cbFunc);
};

/**
 * This initialise the high score system. You need to enter the gameID here.
 */
function initHiScores() {
	if (G_TestHighScore==true) {
		trace("Tu init le highscore!")
	}	
	gProxyObj.setGame_Id("cs_meanwar");
};

/**
 * This will get the high score string from the proxy
 */
function getScoreString() {
	var str = "Oops! The high score list isn't available right now!";
	//! This is the number of characters you got in one row of your textfield
	var l_NumberOfChar:Number = 35;
	if (gProxyObj != undefined) {
		var numScores = gProxyObj.getScoreCount();
		if (numScores>0) {
			var i;
			var thisPlayer;
			var thisName;
			var thisScore;
			str = "";
			for (i=0; i<numScores; i++) {
				thisPlayer = gProxyObj.getScoreItem(i);
				thisName = thisPlayer[0];
				thisScore = fStyleNumber(thisPlayer[1]);
				spaceNb = l_NumberOfChar-thisName.length-thisScore.length-4;
				spaceTXT = "";
				for (var j = 0; j<spaceNb; j++) {
					spaceTXT += " ";
				}
				if (i<9) {
					str += ((i+1)+"   "+thisName+spaceTXT+thisScore+"\n");
				} else if (i<99) {
					str += ((i+1)+"  "+thisName+spaceTXT+thisScore+"\n");
				} else {
					str += ((i+1)+" "+thisName+spaceTXT+thisScore+"\n");
				}
			}
		} else {
			str = "Whoops, the high scores seem to have escaped!";
		}
	}
	if (G_TestHighScore==true) {
		trace("Tu retournes ça = "+str);
	}		
	return str;
};

/**
 * This will list the scores you get from the proxy
 */
function listScores() {
	if (G_TestHighScore==true) {
		trace("Liste les scores..")
	}
	_parent.txt_highScore.text = getScoreString();
};

/**
 * This will try to connect to the database
 */
function cbFunc(thisBool) {
	if (thisBool) {
		listScores();
	} else {
		if (G_TestHighScore==true) {
			trace("CBfunc yé false...")
		}
		_parent.txt_highScore.text = "Oops! The high score list isn’t available right now!";
	}
};

/**
 * This will try to connect to the database
 */
function cbFunc2(thisBool) {
	if (thisBool) {
		listScores();
	} else {
		_parent.txt_highScore.text = "Oops! The high score list isn’t available right now!";
	}
};

/**
 * This will connect you to the server if you want to test
 */
if (G_TestHighScore==true) {
	gProxyObj.setServer("www.nick-q.mtvi.com");
	gProxyObj.setScreenName("DanQuiTest");
	gProxyObj.setIsLoggedIn(true);
}
/**
 * This function will format numbers.
 * @param  l_nNumber -> The number to format     
 * @param  l_nMinimumChar -> The minimum numbers of character to show
 */
function fStyleNumber(_nNumber, _nMinimumChar) {
	_sNumber = String(_nNumber);
	_sNewString = "";
	_nlength = _sNumber.length;
	_nlength = (_nlength/3);
	if (_nlength<=1) {
		_sNewNumber = _sNumber;
		if (_sNewNumber.length<_nMinimumChar) {
			_sNewNumber = "0"+_sNewNumber;
		}
		return _sNewNumber;
	} else {
		for (_nLoop=_nlength; _nLoop>1; _nLoop--) {
			_sNewString = (" "+_sNumber.substr(-3))+_sNewString;
			_sNumber = _sNumber.substr(0, -3);
		}
		_sNewNumber = _sNumber+_sNewString;
		if (_sNewNumber.length<_nMinimumChar) {
			_sNewNumber = "0"+_sNewNumber;
		}
		return _sNewNumber;
	}
}